%%%%%%%%%%%%%%%%%%
function Mn=unprepfn(X,pret1,mm,sm)
%Preprocessing routine. Applies preprocessing to new matrices using the parameters
%calculated on the training set. Performs mean centering ('mean'), autoscaling
%('auto') or no pretreatment ('none')

nt=size(X,1);
switch pret1
    case 'none'
        Mn=X;        
    case 'mean'
        Mn=X+repmat(mm, nt, 1);
    case {'auto', 'pareto'}
        Mn=(X.*repmat(sm,nt, 1))+repmat(mm, nt, 1);
end